/*
 * Decompiled with CFR 0.152.
 */
package irydium.vlab.viewer;

import irydium.b.c;
import irydium.chemistry.Solution;
import irydium.chemistry.g;
import irydium.chemistry.h;
import irydium.vlab.viewer.ConcentrationViewer;
import irydium.vlab.viewer.SolutionBarGraph;
import irydium.vlab.viewer.a;
import irydium.vlab.viewer.d;
import irydium.widgets.b.e;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class SpeciesViewer
extends d
implements irydium.widgets.b.h {
    private String MOLARITY = irydium.international.a.a("Molarity");
    private String GRAMS = irydium.international.a.a("grams");
    private String MOLES = irydium.international.a.a("moles");
    private String S = irydium.international.a.a("s");
    private String AQ = irydium.international.a.a("aq");
    private String selectedState = "";
    private boolean aqEnabled = true;
    private boolean sEnabled = true;
    private boolean gEnabled = true;
    private boolean spectroEnabled = false;
    private JRadioButton aq = new JRadioButton(irydium.international.a.a("Aqueous"), true);
    private JRadioButton s = new JRadioButton(irydium.international.a.a("Solid"), false);
    private JRadioButton spectro = null;
    private SolutionBarGraph graph = new SolutionBarGraph();
    private ConcentrationViewer legend = new ConcentrationViewer(this);
    private static boolean showSpeciesBelowCutoffEnabled = false;
    public static final String SPECTROMETER = "Spectrometer";

    public SpeciesViewer() {
        Serializable serializable = new ButtonGroup();
        if (this.spectroEnabled) {
            this.spectro = new JRadioButton(irydium.international.a.a(SPECTROMETER), false);
            this.spectro.addActionListener(new a(this, SPECTROMETER));
            ((ButtonGroup)serializable).add(this.spectro);
        }
        this.aq.addActionListener(new a(this, "aq"));
        this.s.addActionListener(new a(this, "s"));
        this.graph.a(this);
        this.graph.a(this.legend);
        this.legend.a(this);
        this.legend.a(this.graph);
        ((ButtonGroup)serializable).add(this.aq);
        ((ButtonGroup)serializable).add(this.s);
        ((ButtonGroup)serializable).setSelected(this.aq.getModel(), true);
        this.graph.b("aq");
        this.legend.a("aq");
        serializable = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout((LayoutManager)((Object)serializable));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.aq.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 0));
        ((GridBagLayout)serializable).setConstraints(this.aq, gridBagConstraints);
        this.add(this.aq);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        this.s.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 0));
        ((GridBagLayout)serializable).setConstraints(this.s, gridBagConstraints);
        this.add(this.s);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        if (this.spectro != null) {
            this.spectro.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 0));
            ((GridBagLayout)serializable).setConstraints(this.spectro, gridBagConstraints);
            this.add(this.spectro);
        }
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)serializable).setConstraints(this.graph, gridBagConstraints);
        this.add(this.graph);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        ((GridBagLayout)serializable).setConstraints(this.legend, gridBagConstraints);
        this.add(this.legend);
        this.selectedState = "s";
    }

    public SpeciesViewer(Boolean serializable) {
        Serializable serializable2 = new ButtonGroup();
        this.setMinimumSize(new Dimension(200, 500));
        this.spectroEnabled = (Boolean)serializable;
        if (this.spectroEnabled) {
            this.spectro = new JRadioButton(irydium.international.a.a(SPECTROMETER), false);
            this.spectro.addActionListener(new a(this, SPECTROMETER));
            serializable2.add(this.spectro);
        }
        this.aq.addActionListener(new a(this, "aq"));
        this.s.addActionListener(new a(this, "s"));
        this.graph.a(this);
        this.graph.a(this.legend);
        this.legend.a(this);
        this.legend.a(this.graph);
        serializable2.add(this.aq);
        serializable2.add(this.s);
        serializable2.setSelected(this.aq.getModel(), true);
        this.graph.b("aq");
        this.legend.a("aq");
        serializable = new GridBagLayout();
        serializable2 = new GridBagConstraints();
        this.setLayout((LayoutManager)((Object)serializable));
        ((GridBagConstraints)serializable2).gridx = -1;
        ((GridBagConstraints)serializable2).fill = 0;
        ((GridBagConstraints)serializable2).gridy = 0;
        ((GridBagConstraints)serializable2).anchor = 17;
        ((GridBagConstraints)serializable2).weighty = 0.0;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 0, 0);
        this.aq.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 0));
        ((GridBagLayout)serializable).setConstraints(this.aq, (GridBagConstraints)serializable2);
        this.add(this.aq);
        ((GridBagConstraints)serializable2).weightx = 1.0;
        ((GridBagConstraints)serializable2).anchor = 10;
        this.s.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 0));
        ((GridBagLayout)serializable).setConstraints(this.s, (GridBagConstraints)serializable2);
        this.add(this.s);
        ((GridBagConstraints)serializable2).weightx = 1.0;
        ((GridBagConstraints)serializable2).anchor = 13;
        if (this.spectro != null) {
            this.spectro.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 0));
            ((GridBagLayout)serializable).setConstraints(this.spectro, (GridBagConstraints)serializable2);
            this.add(this.spectro);
        }
        ((GridBagConstraints)serializable2).gridy = 1;
        ((GridBagConstraints)serializable2).anchor = 10;
        ((GridBagConstraints)serializable2).weightx = 1.0;
        ((GridBagConstraints)serializable2).weighty = 0.5;
        ((GridBagConstraints)serializable2).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)serializable2).fill = 1;
        ((GridBagConstraints)serializable2).gridwidth = 0;
        ((GridBagLayout)serializable).setConstraints(this.graph, (GridBagConstraints)serializable2);
        this.add(this.graph);
        ((GridBagConstraints)serializable2).gridy = 2;
        ((GridBagConstraints)serializable2).insets = new Insets(3, 0, 0, 0);
        ((GridBagLayout)serializable).setConstraints(this.legend, (GridBagConstraints)serializable2);
        this.add(this.legend);
        this.selectedState = "s";
    }

    public void load(Properties properties) {
        Object object;
        Object object2;
        Object object3;
        String string;
        int n2;
        Serializable serializable;
        Object object4;
        super.load(properties);
        if (properties.get("aqEnabled") != null) {
            object4 = (String)properties.get("aqEnabled");
            object4 = Boolean.valueOf((String)object4);
            this.aqEnabled = (Boolean)object4;
        }
        if (properties.get("sEnabled") != null) {
            object4 = (String)properties.get("sEnabled");
            object4 = Boolean.valueOf((String)object4);
            this.sEnabled = (Boolean)object4;
        }
        if (properties.get("gEnabled") != null) {
            object4 = (String)properties.get("gEnabled");
            Boolean.valueOf((String)object4);
        }
        if (properties.get("spectroEnabled") != null) {
            object4 = (String)properties.get("spectroEnabled");
            this.spectroEnabled = Boolean.valueOf((String)object4);
        }
        this.aq.setEnabled(this.aqEnabled);
        if (this.spectro != null) {
            this.spectro.setEnabled(this.spectroEnabled);
        }
        this.s.setEnabled(this.sEnabled);
        object4 = null;
        this.selectedState = "aq";
        if (!this.aqEnabled) {
            if (!this.sEnabled) {
                if (this.spectro != null) {
                    this.selectedState = SPECTROMETER;
                    object4 = this.spectro;
                }
            } else {
                this.selectedState = "s";
                object4 = this.s;
            }
        }
        if (object4 != null) {
            ((AbstractButton)object4).setSelected(true);
            this.legend.a(this.selectedState);
            this.graph.b(this.selectedState);
        }
        if (properties.get("aqUnits") != null && !this.selectedState.equals(SPECTROMETER)) {
            object4 = (String)properties.get("aqUnits");
            this.legend.b(irydium.international.a.a((String)object4));
            this.graph.a(irydium.international.a.a((String)object4));
        } else if (this.selectedState.equals(SPECTROMETER)) {
            this.legend.b(irydium.international.a.a("Absorbance"));
            this.graph.a(irydium.international.a.a("Absorbance"));
        } else {
            this.graph.a(this.MOLARITY);
        }
        if (properties.get("unitsToggleEnabled") != null) {
            object4 = (String)properties.get("unitsToggleEnabled");
            serializable = Boolean.valueOf((String)object4);
            this.legend.a((Boolean)serializable);
        } else {
            object4 = Boolean.TRUE;
            this.legend.a((Boolean)object4);
        }
        if (properties.get("defaultCutoff") != null) {
            try {
                object4 = (String)properties.get("defaultCutoff");
                double d2 = Double.valueOf((String)object4);
                this.graph.a(d2);
                this.legend.a(d2);
            }
            catch (Exception exception) {}
        }
        if (properties.get("speciesCutoffs") != null) {
            object4 = (String)properties.get("speciesCutoffs");
            serializable = new Hashtable();
            while (((String)object4).length() > 0 && (n2 = ((String)object4).indexOf(" ")) != -1) {
                string = ((String)object4).substring(0, n2);
                if ((n2 = ((String)(object4 = ((String)object4).substring(n2 + 1))).indexOf(" ")) == -1 && ((String)object4).length() == 0) break;
                if (n2 == -1) {
                    n2 = ((String)object4).length();
                }
                object3 = ((String)object4).substring(0, n2);
                try {
                    object3 = Double.valueOf((String)object3);
                    object2 = h.a();
                    object = object2.b();
                    while (object.hasMoreElements()) {
                        object2 = (g)object.nextElement();
                        String string2 = c.a(((g)object2).b());
                        if (!string2.equals(string)) continue;
                        ((Hashtable)serializable).put(object2, object3);
                        break;
                    }
                }
                catch (Exception exception) {}
                if (n2 == ((String)object4).length()) {
                    object4 = "";
                    continue;
                }
                object4 = ((String)object4).substring(n2 + 1);
            }
            this.graph.a((Hashtable)serializable);
            this.legend.a((Hashtable)serializable);
        }
        if (properties.get("invisibleSpecies") != null) {
            object4 = (String)properties.get("invisibleSpecies");
            serializable = new Vector();
            while (((String)object4).length() > 0) {
                n2 = ((String)object4).indexOf(" ");
                if (n2 == -1) {
                    n2 = ((String)object4).length();
                }
                string = ((String)object4).substring(0, n2);
                object3 = h.a();
                object3 = object3.b();
                while (object3.hasMoreElements()) {
                    object2 = (g)object3.nextElement();
                    object = c.a(((g)object2).b());
                    if (!((String)object).equals(string)) continue;
                    ((Vector)serializable).addElement(object2);
                    break;
                }
                if (n2 == ((String)object4).length()) {
                    object4 = "";
                    continue;
                }
                object4 = ((String)object4).substring(n2 + 1);
            }
            this.graph.a((Vector)serializable);
            this.legend.a((Vector)serializable);
        }
        if (properties.get("showSpeciesBelowCutoffEnabled") != null) {
            object4 = (String)properties.get("showSpeciesBelowCutoffEnabled");
            showSpeciesBelowCutoffEnabled = Boolean.valueOf((String)object4);
            return;
        }
        showSpeciesBelowCutoffEnabled = false;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.graph.setEnabled(bl);
        this.legend.setEnabled(bl);
        bl = this.getCurrentSolution() != null && bl;
        this.aq.setEnabled(bl && this.aqEnabled);
        if (this.spectro != null) {
            this.spectro.setEnabled(bl && this.spectroEnabled);
        }
        this.s.setEnabled(bl && this.sEnabled);
    }

    public void solutionUpdated() {
        this.updateGraph(this.currentSolution);
        super.solutionUpdated();
    }

    public void setCurrentSolution(Solution solution) {
        this.updateGraph(solution);
        super.setCurrentSolution(solution);
    }

    protected void updateGraph(Solution solution) {
        this.graph.setCurrentSolution(solution);
        this.legend.setCurrentSolution(solution);
        boolean bl = solution != null && this.enabled;
        this.aq.setEnabled(bl && this.aqEnabled);
        if (this.spectro != null) {
            this.spectro.setEnabled(bl && this.spectroEnabled);
        }
        this.s.setEnabled(bl && this.sEnabled);
    }

    public void updateSolutionUnits(Solution solution, String string) {
        this.graph.a(solution, string);
        this.legend.a(solution);
    }

    public void selectionPending(e e2) {
    }

    public void selectionChanged(e e2) {
        this.repaint();
    }

    public static boolean isShowSpeciesBelowCutoffEnabled() {
        return showSpeciesBelowCutoffEnabled;
    }

    public static void setShowSpeciesBelowCutoffEnabled(boolean bl) {
        showSpeciesBelowCutoffEnabled = bl;
    }

    static /* synthetic */ SolutionBarGraph access$000(SpeciesViewer speciesViewer) {
        return speciesViewer.graph;
    }

    static /* synthetic */ ConcentrationViewer access$100(SpeciesViewer speciesViewer) {
        return speciesViewer.legend;
    }

    static /* synthetic */ String access$202(SpeciesViewer speciesViewer, String string) {
        speciesViewer.selectedState = string;
        return speciesViewer.selectedState;
    }
}

