/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.oli.log.client;

import edu.cmu.oli.log.client.ActionLog;
import edu.cmu.oli.log.client.SessionLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BufferedLogger {
    private Boolean opened = Boolean.FALSE;
    private URL url;
    private Exception lastException;
    private HttpURLConnection conn;
    private SAXTransformerFactory tf;
    private TransformerHandler hd;
    private Transformer serializer;
    private SimpleDateFormat dateFormat;
    private Vector xmlBuffers;
    private String entUrl = "http://oli0.andrew.cmu.edu/log/XMLEntities.res";

    public BufferedLogger() {
        try {
            this.url = new URL("http://oli0.andrew.cmu.edu/log/server");
        }
        catch (MalformedURLException ex) {
            this.lastException = ex;
        }
        this.dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:SSSSS");
        this.xmlBuffers = new Vector();
    }

    public Boolean setURL(String connURL) {
        this.entUrl = connURL + "/XMLEntities.res";
        try {
            this.url = new URL(connURL + "/server");
        }
        catch (MalformedURLException ex) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public URL getURL() {
        return this.url;
    }

    public Boolean flushLogs() {
        Enumeration e = this.xmlBuffers.elements();
        while (e.hasMoreElements()) {
            Object var8_5;
            OutputStream os;
            StringWriter writer = (StringWriter)e.nextElement();
            try {
                this.conn = (HttpURLConnection)this.url.openConnection();
                this.conn.setRequestMethod("POST");
                this.conn.setDoOutput(true);
                this.conn.setRequestProperty("Content-Type", "text/xml");
                this.conn.setRequestProperty("Checksum", "It's log, it's log");
                this.conn.connect();
                os = this.conn.getOutputStream();
            }
            catch (Exception ex) {
                this.lastException = ex;
                return Boolean.FALSE;
            }
            try {
                try {
                    os.write(writer.toString().getBytes("ISO-8859-1"));
                    os.flush();
                    InputStream is = this.conn.getInputStream();
                }
                catch (IOException ex) {
                    this.lastException = ex;
                    Boolean bl = Boolean.FALSE;
                    var8_5 = null;
                    this.conn.disconnect();
                    return bl;
                }
                var8_5 = null;
                this.conn.disconnect();
            }
            catch (Throwable throwable) {
                var8_5 = null;
                this.conn.disconnect();
                throw throwable;
            }
        }
        return Boolean.TRUE;
    }

    public Exception getLastError() {
        return this.lastException;
    }

    public Boolean logSessionLog(SessionLog log) throws SAXException, UnsupportedEncodingException {
        StringWriter xmlBuffer = new StringWriter();
        this.xmlBuffers.add(xmlBuffer);
        this.tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            this.hd = this.tf.newTransformerHandler();
        }
        catch (TransformerConfigurationException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        this.serializer = this.hd.getTransformer();
        this.serializer.setOutputProperty("{http://xml.apache.org/xslt}entities", this.entUrl);
        this.serializer.setOutputProperty("encoding", "ISO-8859-1");
        this.serializer.setOutputProperty("{http://xml.apache.org/xslt}content-handler", "org.apache.xalan.serialize.SerializerToXML");
        this.hd.setResult(new StreamResult(xmlBuffer));
        try {
            this.hd.startDocument();
        }
        catch (SAXException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        AttributesImpl atts = this.AttributesFromSessionLog(log);
        try {
            this.hd.startElement("", "", "log_session", atts);
            Vector alogs = log.getActionLogVector();
            Enumeration e = alogs.elements();
            while (e.hasMoreElements()) {
                this.logActionLog((ActionLog)e.nextElement());
            }
            this.hd.endElement("", "", "log_session");
        }
        catch (SAXException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - void declaration
     */
    private Boolean logActionLog(ActionLog log) throws SAXException, UnsupportedEncodingException {
        AttributesImpl atts = this.AttributesFromActionLog(log);
        try {
            this.hd.startElement("", "", "log_action", atts);
            if (null != log.getInfo()) {
                char[] sbuffer = URLEncoder.encode(log.getInfo()).toCharArray();
                this.hd.characters(sbuffer, 0, sbuffer.length);
            }
            Enumeration e = log.getBLOBStreams().elements();
            while (e.hasMoreElements()) {
                int ready;
                InputStreamReader sreader = new InputStreamReader((InputStream)e.nextElement(), "UTF-8");
                char[] sbuffer = new char[10240];
                this.hd.startElement("", "", "log_object", new AttributesImpl());
                while ((ready = sreader.read(sbuffer, 0, 10240)) > 0) {
                    void var6_7;
                    this.hd.characters(URLEncoder.encode(new String(sbuffer)).toCharArray(), 0, (int)var6_7);
                }
                this.hd.endElement("", "", "log_object");
            }
            this.hd.endElement("", "", "log_action");
        }
        catch (Exception ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private AttributesImpl AttributesFromSessionLog(SessionLog log) {
        AttributesImpl atts = new AttributesImpl();
        atts.clear();
        atts.addAttribute("", "", "auth_token", "CDATA", log.getAuthToken());
        atts.addAttribute("", "", "session_id", "CDATA", log.getSessionId());
        atts.addAttribute("", "", "user_guid", "CDATA", log.getUserGuid());
        atts.addAttribute("", "", "date_time", "CDATA", this.dateFormat.format(log.getTimeStamp()));
        atts.addAttribute("", "", "timezone", "CDATA", log.getTimezone());
        atts.addAttribute("", "", "class_id", "CDATA", log.getClassId());
        atts.addAttribute("", "", "treatment_id", "CDATA", log.getTreatmentId());
        atts.addAttribute("", "", "assignment_id", "CDATA", log.getAssignmentId());
        atts.addAttribute("", "", "info_type", "CDATA", log.getInfoType());
        return atts;
    }

    private AttributesImpl AttributesFromActionLog(ActionLog log) {
        AttributesImpl atts = new AttributesImpl();
        atts.clear();
        atts.addAttribute("", "", "auth_token", "CDATA", log.getAuthToken());
        atts.addAttribute("", "", "session_id", "CDATA", log.getSessionId());
        atts.addAttribute("", "", "user_guid", "CDATA", log.getUserGuid());
        atts.addAttribute("", "", "date_time", "CDATA", this.dateFormat.format(log.getTimeStamp()));
        atts.addAttribute("", "", "timezone", "CDATA", log.getTimezone());
        atts.addAttribute("", "", "action_id", "CDATA", log.getActionId());
        atts.addAttribute("", "", "source_id", "CDATA", log.getSourceId());
        atts.addAttribute("", "", "external_object_id", "CDATA", log.getExternalObjectId());
        atts.addAttribute("", "", "info_type", "CDATA", log.getInfoType());
        return atts;
    }

    private void printAtts(AttributesImpl atts) {
        int i = 0;
        while (i < atts.getLength()) {
            System.out.println(atts.getQName(i) + " " + atts.getValue(i));
            ++i;
        }
    }
}

