/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.oli.log.client;

import edu.cmu.oli.log.client.ActionLog;
import edu.cmu.oli.log.client.SessionLog;
import edu.cmu.oli.log.client.SupplementLog;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DiskLogger {
    private Boolean opened = Boolean.FALSE;
    private FileOutputStream outfile;
    private Exception lastException;
    private SAXTransformerFactory tf;
    private TransformerHandler hd;
    private Transformer serializer;
    private SimpleDateFormat dateFormat;

    public DiskLogger() {
        try {
            this.outfile = new FileOutputStream("log.dat", true);
        }
        catch (Exception ex) {
            this.lastException = ex;
        }
        this.dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSSS");
        this.tf = (SAXTransformerFactory)TransformerFactory.newInstance();
    }

    public Boolean setOutfile(String filename) {
        try {
            this.outfile = new FileOutputStream(filename, true);
        }
        catch (Exception ex) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public FileOutputStream getOutfile() {
        return this.outfile;
    }

    public Exception getLastError() {
        return this.lastException;
    }

    public Boolean logSessionLog(SessionLog log) throws SAXException, UnsupportedEncodingException {
        StringWriter xmlBuffer = new StringWriter();
        FileOutputStream os = this.outfile;
        try {
            this.hd = this.tf.newTransformerHandler();
        }
        catch (TransformerConfigurationException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        this.serializer = this.hd.getTransformer();
        this.serializer.setOutputProperty("encoding", "ISO-8859-1");
        this.serializer.setOutputProperty("{http://xml.apache.org/xslt}content-handler", "org.apache.xalan.serialize.SerializerToXML");
        this.hd.setResult(new StreamResult(xmlBuffer));
        try {
            this.hd.startDocument();
        }
        catch (SAXException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        AttributesImpl atts = this.AttributesFromSessionLog(log);
        try {
            this.hd.startElement("", "", "log_session_start", atts);
            this.hd.endElement("", "", "log_session_start");
            ((OutputStream)os).write(xmlBuffer.toString().getBytes("ISO-8859-1"));
            os.flush();
            Vector alogs = log.getActionLogVector();
            Enumeration e = alogs.elements();
            while (e.hasMoreElements()) {
                this.logActionLog((ActionLog)e.nextElement());
            }
        }
        catch (SAXException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        catch (IOException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - void declaration
     */
    public Boolean logActionLog(ActionLog log) {
        StringWriter xmlBuffer = new StringWriter();
        AttributesImpl atts = this.AttributesFromActionLog(log);
        FileOutputStream os = this.outfile;
        try {
            this.hd = this.tf.newTransformerHandler();
        }
        catch (TransformerConfigurationException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        this.serializer = this.hd.getTransformer();
        this.serializer.setOutputProperty("encoding", "ISO-8859-1");
        this.hd.setResult(new StreamResult(xmlBuffer));
        try {
            this.hd.startDocument();
        }
        catch (SAXException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        try {
            this.hd.startElement("", "", "log_action", atts);
            Vector asupps = log.getSupplementLogVector();
            Enumeration es = asupps.elements();
            while (es.hasMoreElements()) {
                this.logSupplementLog((SupplementLog)es.nextElement());
            }
            if (null != log.getInfo()) {
                char[] sbuffer = URLEncoder.encode(log.getInfo()).toCharArray();
                this.hd.characters(sbuffer, 0, sbuffer.length);
            }
            Enumeration e = log.getBLOBStreams().elements();
            while (e.hasMoreElements()) {
                int ready;
                InputStreamReader sreader = new InputStreamReader((InputStream)e.nextElement(), "UTF-8");
                char[] sbuffer = new char[10240];
                this.hd.startElement("", "", "log_object", new AttributesImpl());
                while ((ready = sreader.read(sbuffer, 0, 10240)) > 0) {
                    void var10_14;
                    this.hd.characters(URLEncoder.encode(new String(sbuffer)).toCharArray(), 0, (int)var10_14);
                }
                this.hd.endElement("", "", "log_object");
            }
            this.hd.endElement("", "", "log_action");
            this.hd.endDocument();
            ((OutputStream)os).write(xmlBuffer.toString().getBytes("ISO-8859-1"));
            os.flush();
        }
        catch (SAXException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        catch (IOException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - void declaration
     */
    public Boolean logSupplementLog(SupplementLog log) {
        StringWriter xmlBuffer = new StringWriter();
        AttributesImpl atts = this.AttributesFromSupplementLog(log);
        FileOutputStream os = this.outfile;
        try {
            this.hd = this.tf.newTransformerHandler();
        }
        catch (TransformerConfigurationException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        this.serializer = this.hd.getTransformer();
        this.serializer.setOutputProperty("encoding", "ISO-8859-1");
        this.hd.setResult(new StreamResult(xmlBuffer));
        try {
            this.hd.startDocument();
        }
        catch (SAXException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        try {
            this.hd.startElement("", "", "log_supplement", atts);
            if (null != log.getInfo()) {
                char[] sbuffer = URLEncoder.encode(log.getInfo()).toCharArray();
                this.hd.characters(sbuffer, 0, sbuffer.length);
            }
            Enumeration e = log.getBLOBStreams().elements();
            while (e.hasMoreElements()) {
                int ready;
                InputStreamReader sreader = new InputStreamReader((InputStream)e.nextElement(), "UTF-8");
                char[] sbuffer = new char[10240];
                this.hd.startElement("", "", "log_object", new AttributesImpl());
                while ((ready = sreader.read(sbuffer, 0, 10240)) > 0) {
                    void var8_12;
                    this.hd.characters(URLEncoder.encode(new String(sbuffer)).toCharArray(), 0, (int)var8_12);
                }
                this.hd.endElement("", "", "log_object");
            }
            this.hd.endElement("", "", "log_supplement");
            this.hd.endDocument();
            ((OutputStream)os).write(xmlBuffer.toString().getBytes("ISO-8859-1"));
            os.flush();
        }
        catch (SAXException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        catch (IOException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private AttributesImpl AttributesFromSessionLog(SessionLog log) {
        AttributesImpl atts = new AttributesImpl();
        atts.clear();
        atts.addAttribute("", "", "auth_token", "CDATA", log.getAuthToken());
        atts.addAttribute("", "", "session_id", "CDATA", log.getSessionId());
        atts.addAttribute("", "", "user_guid", "CDATA", log.getUserGuid());
        atts.addAttribute("", "", "date_time", "CDATA", this.dateFormat.format(log.getTimeStamp()));
        atts.addAttribute("", "", "timezone", "CDATA", log.getTimezone());
        atts.addAttribute("", "", "class_id", "CDATA", log.getClassId());
        atts.addAttribute("", "", "treatment_id", "CDATA", log.getTreatmentId());
        atts.addAttribute("", "", "assignment_id", "CDATA", log.getAssignmentId());
        atts.addAttribute("", "", "info_type", "CDATA", log.getInfoType());
        return atts;
    }

    private AttributesImpl AttributesFromActionLog(ActionLog log) {
        AttributesImpl atts = new AttributesImpl();
        atts.clear();
        atts.addAttribute("", "", "auth_token", "CDATA", log.getAuthToken());
        atts.addAttribute("", "", "session_id", "CDATA", log.getSessionId());
        atts.addAttribute("", "", "user_guid", "CDATA", log.getUserGuid());
        atts.addAttribute("", "", "date_time", "CDATA", this.dateFormat.format(log.getTimeStamp()));
        atts.addAttribute("", "", "timezone", "CDATA", log.getTimezone());
        atts.addAttribute("", "", "action_id", "CDATA", log.getActionId());
        atts.addAttribute("", "", "source_id", "CDATA", log.getSourceId());
        atts.addAttribute("", "", "external_object_id", "CDATA", log.getExternalObjectId());
        atts.addAttribute("", "", "info_type", "CDATA", log.getInfoType());
        return atts;
    }

    private AttributesImpl AttributesFromSupplementLog(SupplementLog log) {
        AttributesImpl atts = new AttributesImpl();
        atts.clear();
        atts.addAttribute("", "", "action_id", "CDATA", log.getActionId());
        atts.addAttribute("", "", "source_id", "CDATA", log.getSourceId());
        atts.addAttribute("", "", "info_type", "CDATA", log.getInfoType());
        return atts;
    }

    private void printAtts(AttributesImpl atts) {
        int i = 0;
        while (i < atts.getLength()) {
            System.out.println(atts.getQName(i) + " " + atts.getValue(i));
            ++i;
        }
    }
}

