/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.oli.log.client;

import edu.cmu.oli.log.client.ActionLog;
import edu.cmu.oli.log.client.SessionLog;
import edu.cmu.oli.log.client.SupplementLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;

public class StreamLogger {
    private Boolean opened = Boolean.FALSE;
    private URL url;
    private Exception lastException;
    private SimpleDateFormat dateFormat;
    private StringBuffer outDocument;

    public StreamLogger() {
        try {
            this.url = new URL("https://oli0.andrew.cmu.edu/log/server");
        }
        catch (MalformedURLException ex) {
            this.lastException = ex;
        }
        this.dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSSS");
        this.initDocument();
    }

    public Boolean setURL(String connURL) {
        try {
            this.url = new URL(connURL + "/server");
        }
        catch (MalformedURLException ex) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public URL getURL() {
        return this.url;
    }

    public Exception getLastError() {
        return this.lastException;
    }

    private void initDocument() {
        this.outDocument = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    private HttpURLConnection getConnection() {
        HttpURLConnection conn;
        try {
            conn = (HttpURLConnection)this.url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.setRequestProperty("Checksum", "It's log, it's log");
            conn.connect();
            this.initDocument();
        }
        catch (IOException ex) {
            this.lastException = ex;
            return null;
        }
        return conn;
    }

    public Boolean logSessionLog(SessionLog log) throws UnsupportedEncodingException {
        OutputStream os;
        StringWriter xmlBuffer = new StringWriter();
        HttpURLConnection conn = this.getConnection();
        try {
            os = conn.getOutputStream();
        }
        catch (IOException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        this.outDocument.append("<log_session_start ");
        this.AddAttributesFromSessionLog(log);
        this.outDocument.append("/>\n");
        try {
            os.write(this.outDocument.toString().getBytes("ISO-8859-1"));
            os.flush();
            InputStream is = conn.getInputStream();
            conn.disconnect();
            Vector alogs = log.getActionLogVector();
            Enumeration e = alogs.elements();
            while (e.hasMoreElements()) {
                this.initDocument();
                this.logActionLog((ActionLog)e.nextElement());
            }
        }
        catch (IOException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean logActionLog(ActionLog log) {
        OutputStream os;
        StringWriter xmlBuffer = new StringWriter();
        HttpURLConnection conn = this.getConnection();
        try {
            os = conn.getOutputStream();
        }
        catch (IOException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        this.outDocument.append("<log_action ");
        this.AddAttributesFromActionLog(log);
        this.outDocument.append(">");
        try {
            Vector asupps = log.getSupplementLogVector();
            Enumeration es = asupps.elements();
            while (es.hasMoreElements()) {
                this.logSupplementLog((SupplementLog)es.nextElement());
            }
            if (null != log.getInfo()) {
                char[] sbuffer = URLEncoder.encode(log.getInfo()).toCharArray();
                this.outDocument.append(sbuffer, 0, sbuffer.length);
            }
            this.outDocument.append("</log_action>\n");
            os.write(this.outDocument.toString().getBytes("ISO-8859-1"));
            os.flush();
            InputStream is = conn.getInputStream();
        }
        catch (IOException ex) {
            this.lastException = ex;
            return Boolean.FALSE;
        }
        conn.disconnect();
        return Boolean.TRUE;
    }

    private Boolean logSupplementLog(SupplementLog log) {
        this.outDocument.append("<log_supplement ");
        this.AddAttributesFromSupplementLog(log);
        this.outDocument.append(">");
        if (null != log.getInfo()) {
            char[] sbuffer = URLEncoder.encode(log.getInfo()).toCharArray();
            this.outDocument.append(sbuffer, 0, sbuffer.length);
        }
        this.outDocument.append("</log_supplement>");
        return Boolean.TRUE;
    }

    private void AddAttributesFromSessionLog(SessionLog log) {
        this.outDocument.append("auth_token=\"" + log.getAuthToken() + "\" ");
        this.outDocument.append("session_id=\"" + log.getSessionId() + "\" ");
        this.outDocument.append("user_guid=\"" + log.getUserGuid() + "\" ");
        this.outDocument.append("date_time=\"" + this.dateFormat.format(log.getTimeStamp()) + "\" ");
        this.outDocument.append("timezone=\"" + log.getTimezone() + "\" ");
        this.outDocument.append("class_id=\"" + log.getClassId() + "\" ");
        this.outDocument.append("treatment_id=\"" + log.getTreatmentId() + "\" ");
        this.outDocument.append("assignment_id=\"" + log.getAssignmentId() + "\" ");
        this.outDocument.append("info_type=\"" + log.getInfoType() + "\" ");
    }

    private void AddAttributesFromActionLog(ActionLog log) {
        this.outDocument.append("auth_token=\"" + log.getAuthToken() + "\" ");
        this.outDocument.append("session_id=\"" + log.getSessionId() + "\" ");
        this.outDocument.append("user_guid=\"" + log.getUserGuid() + "\" ");
        this.outDocument.append("date_time=\"" + this.dateFormat.format(log.getTimeStamp()) + "\" ");
        this.outDocument.append("timezone=\"" + log.getTimezone() + "\" ");
        this.outDocument.append("action_id=\"" + log.getActionId() + "\" ");
        this.outDocument.append("source_id=\"" + log.getSourceId() + "\" ");
        this.outDocument.append("external_object_id=\"" + log.getExternalObjectId() + "\" ");
        this.outDocument.append("info_type=\"" + log.getInfoType() + "\" ");
    }

    private void AddAttributesFromSupplementLog(SupplementLog log) {
        this.outDocument.append("action=\"" + log.getActionId() + "\" ");
        this.outDocument.append("source_id=\"" + log.getSourceId() + "\" ");
        this.outDocument.append("info_type=\"" + log.getInfoType() + "\" ");
    }
}

